package ru.yandex.stater;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class StaterConfigDefaults implements StaterConfig {
    public static final StaterConfigDefaults INSTANCE =
        new StaterConfigDefaults();

    private static final long DEFAULT_METRICS_TIME_FRAME = 5000L;

    protected StaterConfigDefaults() {
    }

    @Override
    public String prefix() {
        return "reqstats";
    }

    @Override
    public List<MetricBuilder> metrics() {
        final List<MetricBuilder> metrics = new ArrayList<>();
        try {
            final IniConfig fakeConfig =
                new IniConfig(new StringReader(""));
            metrics.add(
                new HttpCodesMetric(fakeConfig));
            metrics.add(
                new RequestTimeMetric(fakeConfig));
            metrics.add(
                new RequestTimeHistogramMetric(fakeConfig));
            return metrics;
        } catch (IOException | ConfigException e) {
            return metrics;
        }
    }

    @Override
    public long metricsTimeFrame() {
        return DEFAULT_METRICS_TIME_FRAME;
    }

    @Override
    public String category() {
        return GolovanPanelConfig.CATEGORY_TIMINGS;
    }

    @Override
    public String title() {
        return null;
    }
}
