package ru.yandex.stater;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class StatersConfigBuilder
    extends AbstractStatersConfigBuilder<StatersConfigBuilder>
{
    public StatersConfigBuilder() {
        super(StatersConfigDefaults.INSTANCE);
    }

    public StatersConfigBuilder(final StatersConfig config) {
        super(config);
    }

    public StatersConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, StatersConfigDefaults.INSTANCE);
    }

    public StatersConfigBuilder(
        final IniConfig config,
        final StatersConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public StatersConfigBuilder self() {
        return this;
    }

    public ImmutableStatersConfig build() {
        return new ImmutableStatersConfig(this);
    }
}

