package ru.yandex.stater;

public class StatsPairStater<T, U> implements PassiveStater<StatsPair<T, U>> {
    private final PassiveStater<? super T> first;
    private final PassiveStater<? super U> second;

    public StatsPairStater(
        final PassiveStater<? super T> first,
        final PassiveStater<? super U> second)
    {
        this.first = first;
        this.second = second;
    }

    @Override
    public void accept(final StatsPair<T, U> value) {
        first.accept(value.first());
        second.accept(value.second());
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        first.stats(statsConsumer);
        second.stats(statsConsumer);
    }
}

