package ru.yandex.stater;

import java.util.function.Supplier;

public class StatsPairStaterFactory<T, U>
    implements Supplier<StatsPairStater<T, U>>
{
    private final Supplier<? extends PassiveStater<? super T>> first;
    private final Supplier<? extends PassiveStater<? super U>> second;

    public StatsPairStaterFactory(
        final Supplier<? extends PassiveStater<? super T>> first,
        final Supplier<? extends PassiveStater<? super U>> second)
    {
        this.first = first;
        this.second = second;
    }

    @Override
    public StatsPairStater<T, U> get() {
        return new StatsPairStater<>(first.get(), second.get());
    }
}

