package ru.yandex.stater;

import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.LongAdder;

import ru.yandex.util.string.StringUtils;

public class ThreadPoolStater implements Stater {
    private final ThreadPoolExecutor executor;
    private final LongAdder rejectedTasksCounter;
    private final String prefix;
    private final String tasksQueueAxxx;
    private final String tasksQueueAmmx;
    private final String tasksQueueAmmm;
    private final String activeWorkersAxxx;
    private final String activeWorkersAmmx;
    private final String activeWorkersAmmm;
    private final String rejectedTasksDmmm;

    public ThreadPoolStater(
        final ThreadPoolExecutor executor,
        final String prefix)
    {
        this(executor, null, prefix);
    }

    public ThreadPoolStater(
        final ThreadPoolExecutor executor,
        final LongAdder rejectedTasksCounter,
        final String prefix)
    {
        this.executor = executor;
        this.rejectedTasksCounter = rejectedTasksCounter;
        this.prefix = prefix;
        tasksQueueAxxx = prefix + "tasks-queue_axxx";
        tasksQueueAmmx = prefix + "tasks-queue_ammx";
        tasksQueueAmmm = prefix + "tasks-queue_ammm";
        activeWorkersAxxx = prefix + "active-workers_axxx";
        activeWorkersAmmx = prefix + "active-workers_ammx";
        activeWorkersAmmm = prefix + "active-workers_ammm";
        rejectedTasksDmmm = prefix + "rejected-tasks_dmmm";
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        int synchronousTasks = executor.getQueue().size();
        statsConsumer.stat(tasksQueueAxxx, synchronousTasks);
        statsConsumer.stat(tasksQueueAmmx, synchronousTasks);
        statsConsumer.stat(tasksQueueAmmm, synchronousTasks);

        int activeWorkers = executor.getActiveCount();
        statsConsumer.stat(activeWorkersAxxx, activeWorkers);
        statsConsumer.stat(activeWorkersAmmx, activeWorkers);
        statsConsumer.stat(activeWorkersAmmm, activeWorkers);

        if (rejectedTasksCounter != null) {
            statsConsumer.stat(rejectedTasksDmmm, rejectedTasksCounter.sum());
        }
    }

    @Override
    public void addToGolovanPanel(
        final GolovanPanel panel,
        final String statsPrefix)
    {
        String prefix = StringUtils.removeSuffix(this.prefix, '-');
        String chartsPrefix = statsPrefix + prefix;
        GolovanChartGroup group =
            new GolovanChartGroup(chartsPrefix, statsPrefix);
        ImmutableGolovanPanelConfig config = panel.config();

        GolovanChart chart = new GolovanChart(
            "-active-workers",
            " active workers",
            false,
            false,
            0d);
        chart.addSignal(
            new GolovanSignal(
                chartsPrefix + "-active-workers_axxx",
                config.tag(),
                "max",
                null,
                0,
                false));
        chart.addSignal(
            new GolovanSignal(
                "div(" + chartsPrefix + "-active-workers_ammm,"
                + statsPrefix + "instance-alive_ammm)",
                config.tag(),
                "average",
                null,
                1,
                false));
        group.addChart(chart);

        chart = new GolovanChart(
            "-tasks-queue",
            " tasks queue size",
            false,
            false,
            0d);
        chart.addSignal(
            new GolovanSignal(
                chartsPrefix + "-tasks-queue_axxx",
                config.tag(),
                "max",
                null,
                0,
                false));
        chart.addSignal(
            new GolovanSignal(
                "div(" + chartsPrefix + "-tasks-queue_ammm,"
                + statsPrefix + "instance-alive_ammm)",
                config.tag(),
                "average",
                null,
                1,
                false));
        group.addChart(chart);

        if (rejectedTasksCounter != null) {
            chart = new GolovanChart(
                "-rejected-tasks",
                " rejected tasks (rps)",
                false,
                true,
                0d);
            chart.addSplitSignal(
                config,
                chartsPrefix + "-rejected-tasks_dmmm",
                3,
                false,
                false);
            group.addChart(chart);
        }

        panel.addCharts(
            GolovanPanelConfig.CATEGORY_THREAD_POOLS,
            null,
            group);
    }
}

