package ru.yandex.stater;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import ru.yandex.collection.IntPair;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.util.string.StringUtils;

public class TitledGolovanChartsGroup {
    private final List<GolovanChartGroup> groups = new ArrayList<>();
    private final String title;
    private final int maxCols;
    private final Map<String, IntPair<String>> rename;

    public TitledGolovanChartsGroup(
        final String title,
        final int maxCols,
        final Map<String, IntPair<String>> rename)
    {
        this.title = title;
        this.maxCols = maxCols;
        this.rename = rename;
    }

    public String title() {
        return title;
    }

    public void addCharts(final GolovanChartGroup group) {
        int size = groups.size();
        if (size == 0) {
            groups.add(group);
            return;
        }
        String id = group.id();
        IntPair<String> leftRename = rename.get(id);
        int pos;
        if (leftRename == null) {
            pos = size;
        } else {
            int order = leftRename.first();
            pos = 0;
            while (pos < size) {
                GolovanChartGroup nextGroup = groups.get(pos);
                IntPair<String> groupRename = rename.get(nextGroup.id());
                if (groupRename == null || order < groupRename.first()) {
                    break;
                }
                ++pos;
            }
        }
        groups.add(pos, group);
    }

    // Returns number of rows written
    public int writeValue(
        final JsonWriterBase writer,
        final int startRow)
        throws IOException
    {
        int row;
        if (title == null) {
            row = startRow;
        } else {
            row = startRow + 1;
            writer.startObject();
            writer.key("type");
            writer.value("text");
            writer.key("text");
            writer.value(title);
            writer.key("row");
            writer.value(startRow);
            writer.key("col");
            writer.value(1);
            writer.key("height");
            writer.value(1);
            writer.key("width");
            writer.value(maxCols);
            writer.endObject();
        }
        int col = 0;
        int groupsCount = groups.size();
        for (int i = 0; i < groupsCount; ++i) {
            GolovanChartGroup group = groups.get(i);
            List<GolovanChart> charts = group.charts();
            int size = charts.size();
            if (col != 0 && col + size > maxCols) {
                col = 0;
                ++row;
            }
            String id = group.id();
            IntPair<String> namePair = rename.get(id);
            String name;
            if (namePair == null) {
                name = null;
            } else {
                name = namePair.second();
            }
            for (int j = 0; j < size; ++j) {
                GolovanChart chart = charts.get(j);
                String fullId = id + chart.idSuffix();
                IntPair<String> chartRename = rename.get(fullId);
                String chartName;
                if (chartRename == null) {
                    chartName = name;
                } else {
                    chartName = chartRename.second();
                }
                if (chartName == null) {
                    chartName =
                        StringUtils.removePrefix(fullId, group.statsPrefix());
                }
                if (chartName.isEmpty()) {
                    continue;
                }
                chart.writeValue(writer, id, chartName, row, ++col);
            }
        }
        if (col != 0) {
            ++row;
        }
        return row - startRow;
    }
}

