package ru.yandex.stater;

public class TriplexStater<T> implements PassiveStater<T> {
    private final PassiveStater<? super T> first;
    private final PassiveStater<? super T> second;
    private final PassiveStater<? super T> third;

    public TriplexStater(
        final PassiveStater<? super T> first,
        final PassiveStater<? super T> second,
        final PassiveStater<? super T> third)
    {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    @Override
    public void accept(final T value) {
        first.accept(value);
        second.accept(value);
        third.accept(value);
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        first.stats(statsConsumer);
        second.stats(statsConsumer);
        third.stats(statsConsumer);
    }
}

