package ru.yandex.stater;

import java.util.function.Supplier;

public class TriplexStaterFactory<T> implements Supplier<TriplexStater<T>> {
    private final Supplier<? extends PassiveStater<? super T>> first;
    private final Supplier<? extends PassiveStater<? super T>> second;
    private final Supplier<? extends PassiveStater<? super T>> third;

    public TriplexStaterFactory(
        final Supplier<? extends PassiveStater<? super T>> first,
        final Supplier<? extends PassiveStater<? super T>> second,
        final Supplier<? extends PassiveStater<? super T>> third)
    {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    @Override
    public TriplexStater<T> get() {
        return new TriplexStater<>(first.get(), second.get(), third.get());
    }
}

