package ru.yandex.stater;

import java.util.Set;
import java.util.function.Supplier;

import ru.yandex.collection.IterableWrapper;

public class UniqueKeysStater<T> implements Stater {
    private final IterableWrapper<T> data;
    private final Supplier<? extends Set<? super T>> setFactory;
    private final String signalName;

    public UniqueKeysStater(
        final Iterable<T> data,
        final Supplier<? extends Set<? super T>> setFactory,
        final String signalName)
    {
        this.data = new IterableWrapper<>(data);
        this.setFactory = setFactory;
        this.signalName = signalName;
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        Set<? super T> set = setFactory.get();
        set.addAll(data);
        statsConsumer.stat(signalName, set.size());
    }
}

