package ru.yandex.client.tvm2;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractTvm2ClientConfigBuilder
    <T extends AbstractTvm2ClientConfigBuilder<T>>
    implements ConfigBuilder<T>, Tvm2ClientConfig
{
    private String destinationClientId;
    private long renewalInterval;

    protected AbstractTvm2ClientConfigBuilder(final Tvm2ClientConfig config) {
        destinationClientId(config.destinationClientId());
        renewalInterval(config.renewalInterval());
    }

    protected AbstractTvm2ClientConfigBuilder(
        final IniConfig config,
        final Tvm2ClientConfig defaults)
        throws ConfigException
    {
        destinationClientId(
            DESTINATION_CLIENT_ID.extract(
                config,
                defaults.destinationClientId()));
        renewalInterval(
            RENEWAL_INTERVAL.extract(config, defaults.renewalInterval()));
    }

    @Override
    public String destinationClientId() {
        return destinationClientId;
    }

    public T destinationClientId(final String destinationClientId) {
        this.destinationClientId = destinationClientId;
        return self();
    }

    @Override
    public long renewalInterval() {
        return renewalInterval;
    }

    public T renewalInterval(final long renewalInterval) {
        this.renewalInterval = renewalInterval;
        return self();
    }
}

