package ru.yandex.client.tvm2;

import ru.yandex.http.config.AbstractHttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.passport.tvmauth.BlackboxEnv;

public abstract class AbstractTvm2ServiceConfigBuilder
    <T extends AbstractTvm2ServiceConfigBuilder<T>>
    extends AbstractHttpHostConfigBuilder<T>
    implements Tvm2ServiceConfig
{
    private BlackboxEnv blackboxEnv;
    private int clientId;
    private String secret;
    private long keysRenewalInterval;

    protected AbstractTvm2ServiceConfigBuilder(final Tvm2ServiceConfig config) {
        super(config);
        blackboxEnv(config.blackboxEnv());
        clientId(config.clientId());
        secret(config.secret());
        keysRenewalInterval(config.keysRenewalInterval());
    }

    protected AbstractTvm2ServiceConfigBuilder(
        final IniConfig config,
        final Tvm2ServiceConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        blackboxEnv(BLACKBOX_ENV.extract(config, defaults.blackboxEnv()));
        clientId(CLIENT_ID.extract(config, defaults.clientId()));
        secret(SECRET.extract(config, defaults.secret()));
        keysRenewalInterval(
            KEYS_RENEWAL_INTERVAL.extract(
                config,
                defaults.keysRenewalInterval()));
    }

    @Override
    public BlackboxEnv blackboxEnv() {
        return blackboxEnv;
    }

    public T blackboxEnv(final BlackboxEnv blackboxEnv) {
        this.blackboxEnv = blackboxEnv;
        return self();
    }

    @Override
    public int clientId() {
        return clientId;
    }

    public T clientId(final int clientId) {
        this.clientId = clientId;
        return self();
    }

    @Override
    public String secret() {
        return secret;
    }

    public T secret(final String secret) {
        this.secret = secret;
        return self();
    }

    @Override
    public long keysRenewalInterval() {
        return keysRenewalInterval;
    }

    public T keysRenewalInterval(final long keysRenewalInterval) {
        this.keysRenewalInterval = keysRenewalInterval;
        return self();
    }
}

