package ru.yandex.client.tvm2;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableTvm2ClientConfig
    implements ImmutableConfig, Tvm2ClientConfig
{
    private final String destinationClientId;
    private final long renewalInterval;

    public ImmutableTvm2ClientConfig(final Tvm2ClientConfig config)
        throws ConfigException
    {
        destinationClientId =
            DESTINATION_CLIENT_ID.validate(config.destinationClientId());
        renewalInterval = RENEWAL_INTERVAL.validate(config.renewalInterval());
    }

    @Override
    public String destinationClientId() {
        return destinationClientId;
    }

    @Override
    public long renewalInterval() {
        return renewalInterval;
    }
}

