package ru.yandex.client.tvm2;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.passport.tvmauth.BlackboxEnv;

public class ImmutableTvm2ServiceConfig
    extends ImmutableHttpHostConfig
    implements Tvm2ServiceConfig
{
    private final BlackboxEnv blackboxEnv;
    private final int clientId;
    private final String secret;
    private final long keysRenewalInterval;

    public ImmutableTvm2ServiceConfig(final Tvm2ServiceConfig config)
        throws ConfigException
    {
        super(config);
        blackboxEnv = BLACKBOX_ENV.validate(config.blackboxEnv());
        clientId = CLIENT_ID.validate(config.clientId());
        secret = SECRET.validate(config.secret());
        keysRenewalInterval =
            KEYS_RENEWAL_INTERVAL.validate(config.keysRenewalInterval());
        if (clientId == 0 && secret != null) {
            throw new ConfigException("Secret is set but client id is 0");
        }
    }

    @Override
    public BlackboxEnv blackboxEnv() {
        return blackboxEnv;
    }

    @Override
    public int clientId() {
        return clientId;
    }

    @Override
    public String secret() {
        return secret;
    }

    @Override
    public long keysRenewalInterval() {
        return keysRenewalInterval;
    }

    public static ImmutableTvm2ServiceConfig create(
        final Tvm2ServiceConfig config)
        throws ConfigException
    {
        if (config == null) {
            return null;
        } else {
            return new ImmutableTvm2ServiceConfig(config);
        }
    }
}

