package ru.yandex.client.tvm2;

import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.DoubleToLongValidator;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.PositiveValidator;

public interface Tvm2ClientConfig {
    ParameterConfig<String> DESTINATION_CLIENT_ID = new ParameterConfig<>(
        "destination-client-id",
        x -> x,
        NonEmptyValidator.INSTANCE);
    ParameterConfig<Long> RENEWAL_INTERVAL = new ParameterConfig<>(
        "renewal-interval",
        DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
        PositiveValidator.instance());

    String destinationClientId();

    long renewalInterval();
}

