package ru.yandex.client.tvm2;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class Tvm2ClientConfigBuilder
    extends AbstractTvm2ClientConfigBuilder<Tvm2ClientConfigBuilder>
{
    public Tvm2ClientConfigBuilder() {
        this(Tvm2ClientConfigDefaults.INSTANCE);
    }

    public Tvm2ClientConfigBuilder(final Tvm2ClientConfig config) {
        super(config);
    }

    public Tvm2ClientConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, Tvm2ClientConfigDefaults.INSTANCE);
    }

    public Tvm2ClientConfigBuilder(
        final IniConfig config,
        final Tvm2ClientConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public Tvm2ClientConfigBuilder self() {
        return this;
    }

    public ImmutableTvm2ClientConfig build() throws ConfigException {
        return new ImmutableTvm2ClientConfig(this);
    }
}

