package ru.yandex.client.tvm2;

import ru.yandex.function.GenericFunction;
import ru.yandex.function.NullToDefaultFunction;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.DoubleToLongValidator;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.EnumParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeValidator;
import ru.yandex.parser.string.PositiveValidator;
import ru.yandex.passport.tvmauth.BlackboxEnv;

public interface Tvm2ServiceConfig extends HttpHostConfig {
    ParameterConfig<BlackboxEnv> BLACKBOX_ENV = new ParameterConfig<>(
        "blackbox-env",
        new EnumParser<>(BlackboxEnv.class),
        GenericFunction.identity());
    ParameterConfig<Integer> CLIENT_ID = new ParameterConfig<>(
        "client-id",
        Integer::parseInt,
        NonNegativeValidator.instance());
    ParameterConfig<String> SECRET = new ParameterConfig<>(
        "secret",
        GenericFunction.identity(),
        new NullToDefaultFunction<>(NonEmptyValidator.INSTANCE),
        true);
    ParameterConfig<Long> KEYS_RENEWAL_INTERVAL = new ParameterConfig<>(
        "keys-renewal-interval",
        DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
        PositiveValidator.instance());

    BlackboxEnv blackboxEnv();

    int clientId();

    String secret();

    long keysRenewalInterval();
}

