package ru.yandex.client.tvm2;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class Tvm2ServiceConfigBuilder
    extends AbstractTvm2ServiceConfigBuilder<Tvm2ServiceConfigBuilder>
{
    public Tvm2ServiceConfigBuilder() {
        this(Tvm2ServiceConfigDefaults.INSTANCE);
    }

    public Tvm2ServiceConfigBuilder(final Tvm2ServiceConfig config) {
        super(config);
    }

    public Tvm2ServiceConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, Tvm2ServiceConfigDefaults.INSTANCE);
    }

    public Tvm2ServiceConfigBuilder(
        final IniConfig config,
        final Tvm2ServiceConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public Tvm2ServiceConfigBuilder self() {
        return this;
    }

    public ImmutableTvm2ServiceConfig build() throws ConfigException {
        return new ImmutableTvm2ServiceConfig(this);
    }
}

