package ru.yandex.parser.uri;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpRequest;

public class CgiParams
    extends HashMap<String, List<String>>
    implements CgiParamsBase
{
    private static final long serialVersionUID = 0;

    public CgiParams(final HttpRequest request) {
        this(new UriParser(request.getRequestLine().getUri()).queryParser());
    }

    public CgiParams(final String query) {
        this(new QueryParser(query));
    }

    public CgiParams(final QueryParser parser) {
        for (QueryParameter param: parser) {
            add(param.name(), CgiParamsBase.valueToString(param.value()));
        }
    }

    public CgiParams(final Map<String, ? extends Collection<String>> params) {
        for (Map.Entry<String, ? extends Collection<String>> entry
            : params.entrySet())
        {
            put(entry.getKey(), new ArrayList<>(entry.getValue()));
        }
    }

    @Override
    public String getOrNull(final String name) {
        List<String> values = get(name);
        if (values == null) {
            return null;
        } else {
            return values.get(0);
        }
    }

    @Override
    public String getLastOrNull(final String name) {
        List<String> values = get(name);
        if (values == null) {
            return null;
        } else {
            return values.get(values.size() - 1);
        }
    }

    @Override
    public Iterator<String> getAllOrNull(final String name) {
        List<String> values = get(name);
        if (values == null) {
            return null;
        } else {
            return values.iterator();
        }
    }

    public List<String> getAll(final String name) {
        List<String> values = get(name);
        if (values == null) {
            return Collections.emptyList();
        } else {
            return values;
        }
    }

    public void replace(final String name, final String value) {
        if (value == null) {
            remove(name);
        } else {
            List<String> values = get(name);
            if (values == null) {
                values = new ArrayList<>(1);
                put(name, values);
            } else {
                values.clear();
            }
            values.add(value);
        }
    }

    public void replace(final String name, final Collection<String> values) {
        if (values == null || values.isEmpty()) {
            remove(name);
        } else {
            put(name, new ArrayList<>(values));
        }
    }

    public void add(final String name, final String value) {
        List<String> values = get(name);
        if (values == null) {
            values = new ArrayList<>(1);
            put(name, values);
        }
        values.add(value);
    }
}

