package ru.yandex.parser.uri;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.string.ValuesStorage;

public interface CgiParamsBase extends ValuesStorage<BadRequestException> {
    static String valueToString(final PctEncodedString value) {
        try {
            return value.decode();
        } catch (BadRequestException e) {
            return value.toString();
        }
    }

    @Override
    default BadRequestException parameterNotSetException(final String name) {
        return new BadRequestException("Parameter " + name + " is not set");
    }

    @Override
    default BadRequestException parseFailedException(
        final String name,
        final String value,
        final Throwable cause)
    {
        return new BadRequestException(
            "Failed to parse parameter " + name
            + " with value '" + value + '\'',
            cause);
    }
}

