package ru.yandex.parser.uri;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OpenApiDocumentation {
    public static final Map<OpenApiPath, OpenApiPath> PATHES = new ConcurrentHashMap<>();

    private static volatile boolean enabled =
        Boolean.TRUE.toString().equalsIgnoreCase(
            System.getenv().getOrDefault("GENERATE_OPENAPI_JSON", Boolean.FALSE.toString()));

    public static boolean enabled() {
        return enabled;
    }

    public static void enable() {
        enabled = true;
    }

    public static Map<OpenApiPath, OpenApiPath> paths() {
        return PATHES;
    }
}
