package ru.yandex.parser.uri;

import java.util.ArrayList;
import java.util.List;

public class OpenApiParameter {
    private String name;
    private Area area = Area.QUERY;
    private boolean required;
    private String description;
    private List<String> examples = new ArrayList<>();
    private Type type;
    private Object defaultValue;
    private Object parser;

    public OpenApiParameter(
        final String name,
        final boolean required,
        final String description,
        final List<String> examples,
        final Type type,
        final Object defaultValue)
    {
        this.name = name;
        this.required = required;
        this.description = description;
        this.examples = examples;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public OpenApiParameter() {
    }

    public String name() {
        return name;
    }

    public OpenApiParameter name(final String name) {
        this.name = name;
        return this;
    }

    public boolean required() {
        return required;
    }

    public OpenApiParameter required(final boolean required) {
        this.required = required;
        return this;
    }

    public String description() {
        return description;
    }

    public OpenApiParameter description(final String description) {
        this.description = description;
        return this;
    }

    public List<String> examples() {
        return examples;
    }

    public OpenApiParameter examples(final List<String> examples) {
        this.examples = examples;
        return this;
    }

    public Type type() {
        return type;
    }

    public OpenApiParameter type(final Type type) {
        this.type = type;
        return this;
    }

    public Object defaultValue() {
        return defaultValue;
    }

    public OpenApiParameter defaultValue(final Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Object parser() {
        return parser;
    }

    public OpenApiParameter parser(final Object parser) {
        this.parser = parser;
        return this;
    }

    public Area area() {
        return area;
    }

    public OpenApiParameter area(final Area area) {
        this.area = area;
        return this;
    }

    public enum Type {
        STRING,
        NUMBER,
        INTEGER,
        BOOLEAN,
        ARRAY,
        OBJECT
    }

    public enum Area {
        BODY,
        HEADER,
        QUERY
    }
}
