package ru.yandex.parser.uri;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class OpenApiPath {
    private final String method;
    private final String path;
    private final Map<Integer, String> responses = new LinkedHashMap<>();
    private final Map<String, List<OpenApiParameter>> params = new LinkedHashMap<>();

    public OpenApiPath(final String method, final String path) {
        this.method = method;
        this.path = path;
    }

    public synchronized OpenApiPath param(final String name, final OpenApiParameter parameter) {
        final List<OpenApiParameter> list = params.computeIfAbsent(name, (k) -> new ArrayList<>());
        list.add(parameter);

        return this;
    }

    public synchronized void response(final int status, final String body) {
        responses.put(status, body);
    }

    public Map<Integer, String> responses() {
        return responses;
    }

    public synchronized List<OpenApiParameter> params() {
        List<OpenApiParameter> result = new ArrayList<>();
        for (Map.Entry<String, List<OpenApiParameter>> entry: params.entrySet()) {
            if (entry.getValue().isEmpty()) {
                continue;
            }

            List<OpenApiParameter> parameters = entry.getValue();
            OpenApiParameter parameter = entry.getValue().get(entry.getValue().size() - 1);
            Set<String> examples = new LinkedHashSet<>();
            for (int i = 0; i < parameters.size(); i++) {
                OpenApiParameter current = parameters.get(i);
                examples.addAll(current.examples());
            }

            parameter.examples(new ArrayList<>(examples));
            result.add(parameter);
        }

        return result;
    }

    public String method() {
        return method;
    }

    public String path() {
        return path;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenApiPath)) {
            return false;
        }
        final OpenApiPath that = (OpenApiPath) o;
        return method.equals(that.method) && path.equals(that.path);
    }

    @Override
    public int hashCode() {
        return Objects.hash(method, path);
    }
}
