package ru.yandex.parser.uri;

import java.nio.charset.CharacterCodingException;

import ru.yandex.function.CharArrayProcessable;
import ru.yandex.http.util.BadRequestException;

public class PctEncodedString extends CharArrayProcessable {
    private final PctDecoder decoder;

    public PctEncodedString(final String str, final PctDecoder decoder) {
        this(str.toCharArray(), decoder);
    }

    PctEncodedString(final char[] buf, final PctDecoder decoder) {
        this(buf, 0, buf.length, decoder);
    }

    // CSOFF: ParameterNumber
    PctEncodedString(
        final char[] buf,
        final int off,
        final int len,
        final PctDecoder decoder)
    {
        super(buf, off, len);
        this.decoder = decoder;
    }
    // CSON: ParameterNumber

    public PctDecoder decoder() {
        return decoder;
    }

    private String doDecode() throws CharacterCodingException {
        if (decoder == null) {
            return toString();
        } else {
            decoder.process(buf, off, len);
            return decoder.toString();
        }
    }

    public String decode() throws BadRequestException {
        try {
            return doDecode();
        } catch (CharacterCodingException e) {
            throw new BadRequestException(
                "Malformed pct-encoded string: " + this,
                e);
        }
    }

    public String decodeOrRaw() {
        try {
            return doDecode();
        } catch (CharacterCodingException e) {
            return toString();
        }
    }
}

