package ru.yandex.parser.uri;

public abstract class PctEncodingRule {
    public static final PctEncodingRule PATH = new PathPctEncodingRule();
    public static final PctEncodingRule QUERY = new QueryPctEncodingRule();
    public static final PctEncodingRule FRAGMENT =
        new FragmentPctEncodingRule();

    protected abstract boolean[] getEncodingTable();

    public boolean[] encodingTable() {
        return getEncodingTable();
    }

    public static class PathPctEncodingRule extends PctEncodingRule {
        private final boolean[] encodingTable = new boolean[] {
            /*            0      1      2      3      4      5      6      7 */
            /*             8      9      A      B      C      D      E      F*/
            /* 0x00 */ false, false, false, false, false, false, false, false,
            /* 0x08 */ false, false, false, false, false, false, false, false,
            /* 0x10 */ false, false, false, false, false, false, false, false,
            /* 0x18 */ false, false, false, false, false, false, false, false,
            /* 0x20 */ false,  true, false, false,  true, false,  true,  true,
            /* 0x28 */  true,  true,  true,  true,  true,  true,  true, false,
            /* 0x30 */  true,  true,  true,  true,  true,  true,  true,  true,
            /* 0x38 */  true,  true,  true,  true, false,  true, false, false,
            /* 0x40 */  true,  true,  true,  true,  true,  true,  true,  true,
            /* 0x48 */  true,  true,  true,  true,  true,  true,  true,  true,
            /* 0x50 */  true,  true,  true,  true,  true,  true,  true,  true,
            /* 0x58 */  true,  true,  true, false, false, false, false,  true,
            /* 0x60 */ false,  true,  true,  true,  true,  true,  true,  true,
            /* 0x68 */  true,  true,  true,  true,  true,  true,  true,  true,
            /* 0x70 */  true,  true,  true,  true,  true,  true,  true,  true,
            /* 0x78 */  true,  true,  true, false, false, false,  true, false
        };

        @Override
        protected boolean[] getEncodingTable() {
            return encodingTable;
        }
    }

    public static class FragmentPctEncodingRule extends PctEncodingRule {
        private final boolean[] encodingTable;

        public FragmentPctEncodingRule() {
            encodingTable = new PathPctEncodingRule().encodingTable();
            encodingTable['/'] = true;
            encodingTable['?'] = true;
        }

        @Override
        protected boolean[] getEncodingTable() {
            return encodingTable;
        }
    }

    public static class QueryPctEncodingRule extends PctEncodingRule {
        private final boolean[] encodingTable;

        public QueryPctEncodingRule() {
            encodingTable = new FragmentPctEncodingRule().encodingTable();
            encodingTable['+'] = false;
            encodingTable['&'] = false;
            encodingTable['='] = false;
        }

        @Override
        protected boolean[] getEncodingTable() {
            return encodingTable;
        }
    }
}

