package ru.yandex.parser.uri;

import java.util.Iterator;
import java.util.NoSuchElementException;

import org.apache.http.HttpRequest;

public class ScanningCgiParams implements CgiParamsBase {
    private final QueryParser parser;

    public ScanningCgiParams(final HttpRequest request) {
        this(new UriParser(request.getRequestLine().getUri()).queryParser());
    }

    public ScanningCgiParams(final String query) {
        this(new QueryParser(query));
    }

    public ScanningCgiParams(final QueryParser parser) {
        this.parser = parser;
    }

    @Override
    public String getOrNull(final String name) {
        for (QueryParameter param: parser) {
            if (param.name().equals(name)) {
                return CgiParamsBase.valueToString(param.value());
            }
        }
        return null;
    }

    @Override
    public String getLastOrNull(final String name) {
        PctEncodedString value = null;
        for (QueryParameter param: parser) {
            if (param.name().equals(name)) {
                value = param.value();
            }
        }
        if (value == null) {
            return null;
        } else {
            return CgiParamsBase.valueToString(value);
        }
    }

    @Override
    public Iterator<String> getAllOrNull(final String name) {
        Iterator<QueryParameter> iter = parser.iterator();
        while (iter.hasNext()) {
            QueryParameter param = iter.next();
            if (param.name().equals(name)) {
                return new QueryParameterIterator(
                    name,
                    iter,
                    CgiParamsBase.valueToString(param.value()));
            }
        }
        return null;
    }

    private static class QueryParameterIterator implements Iterator<String> {
        private final String name;
        private final Iterator<QueryParameter> iter;
        private String firstValue;

        QueryParameterIterator(
            final String name,
            final Iterator<QueryParameter> iter,
            final String firstValue)
        {
            this.name = name;
            this.iter = iter;
            this.firstValue = firstValue;
        }

        @Override
        public boolean hasNext() {
            return firstValue != null;
        }

        @Override
        public String next() {
            if (firstValue == null) {
                throw new NoSuchElementException();
            } else {
                String result = firstValue;
                firstValue = null;
                while (iter.hasNext()) {
                    QueryParameter param = iter.next();
                    if (param.name().equals(name)) {
                        firstValue =
                            CgiParamsBase.valueToString(param.value());
                        break;
                    }
                }
                return result;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

