package ru.yandex.jniwrapper;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractJniWrapperConfigBuilder
    <T extends AbstractJniWrapperConfigBuilder<T>>
    implements ConfigBuilder<T>, JniWrapperConfig
{
    private String libraryName;
    private String ctorName;
    private String dtorName;
    private String mainName;
    private String main16Name;
    private String logrotateName;
    private String reloadName;
    private String freeName;
    private String config;
    private int workers;
    private int queueSize;

    protected AbstractJniWrapperConfigBuilder(final JniWrapperConfig config) {
        libraryName(config.libraryName());
        ctorName(config.ctorName());
        dtorName(config.dtorName());
        mainName(config.mainName());
        main16Name(config.main16Name());
        logrotateName(config.logrotateName());
        reloadName(config.reloadName());
        freeName(config.freeName());
        this.config(config.config());
        workers(config.workers());
        queueSize(config.queueSize());
    }

    protected AbstractJniWrapperConfigBuilder(
        final IniConfig config,
        final JniWrapperConfig defaults)
        throws ConfigException
    {
        libraryName(LIBRARY_NAME.extract(config, defaults.libraryName()));
        ctorName(CTOR_NAME.extract(config, defaults.ctorName()));
        dtorName(DTOR_NAME.extract(config, defaults.dtorName()));
        mainName(MAIN_NAME.extract(config, defaults.mainName()));
        main16Name(MAIN16_NAME.extract(config, defaults.main16Name()));
        logrotateName(
            LOGROTATE_NAME.extract(
                config,
                defaults.logrotateName()));
        reloadName(
            RELOAD_NAME.extract(
                config,
                defaults.reloadName()));
        freeName(FREE_NAME.extract(config, defaults.freeName()));
        this.config(CONFIG.extract(config, defaults.config()));
        workers(WORKERS.extract(config, defaults.workers()));
        if (workers > 0) {
            queueSize(QUEUE_SIZE.extract(config, defaults.queueSize()));
        } else {
            queueSize(0);
        }
    }

    @Override
    public String libraryName() {
        return libraryName;
    }

    public T libraryName(final String libraryName) {
        this.libraryName = libraryName;
        return self();
    }

    @Override
    public String ctorName() {
        return ctorName;
    }

    public T ctorName(final String ctorName) {
        this.ctorName = ctorName;
        return self();
    }

    @Override
    public String dtorName() {
        return dtorName;
    }

    public T dtorName(final String dtorName) {
        this.dtorName = dtorName;
        return self();
    }

    @Override
    public String mainName() {
        return mainName;
    }

    public T mainName(final String mainName) {
        this.mainName = mainName;
        return self();
    }

    @Override
    public String main16Name() {
        return main16Name;
    }

    public T main16Name(final String main16Name) {
        this.main16Name = main16Name;
        return self();
    }

    @Override
    public String logrotateName() {
        return logrotateName;
    }

    public T logrotateName(final String logrotateName) {
        this.logrotateName = logrotateName;
        return self();
    }

    @Override
    public String reloadName() {
        return reloadName;
    }

    public T reloadName(final String reloadName) {
        this.reloadName = reloadName;
        return self();
    }

    @Override
    public String freeName() {
        return freeName;
    }

    public T freeName(final String freeName) {
        this.freeName = freeName;
        return self();
    }

    @Override
    public String config() {
        return config;
    }

    public T config(final String config) {
        this.config = config;
        return self();
    }

    @Override
    public int workers() {
        return workers;
    }

    public T workers(final int workers) {
        this.workers = workers;
        return self();
    }

    @Override
    public int queueSize() {
        return queueSize;
    }

    public T queueSize(final int queueSize) {
        this.queueSize = queueSize;
        return self();
    }
}

