package ru.yandex.jniwrapper;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableJniWrapperConfig
    implements ImmutableConfig, JniWrapperConfig
{
    private final String libraryName;
    private final String ctorName;
    private final String dtorName;
    private final String mainName;
    private final String main16Name;
    private final String logrotateName;
    private final String reloadName;
    private final String freeName;
    private final String config;
    private final int workers;
    private final int queueSize;

    public ImmutableJniWrapperConfig(final JniWrapperConfig config)
        throws ConfigException
    {
        libraryName = LIBRARY_NAME.validate(config.libraryName());
        ctorName = CTOR_NAME.validate(config.ctorName());
        dtorName = CTOR_NAME.validate(config.dtorName());
        mainName = MAIN_NAME.validate(config.mainName());
        main16Name = MAIN16_NAME.validate(config.main16Name());
        logrotateName = LOGROTATE_NAME.validate(config.logrotateName());
        reloadName = RELOAD_NAME.validate(config.reloadName());
        freeName = FREE_NAME.validate(config.freeName());
        this.config = CONFIG.validate(config.config());
        workers = WORKERS.validate(config.workers());
        if (workers > 0) {
            queueSize = QUEUE_SIZE.validate(config.queueSize());
        } else {
            queueSize = 0;
        }

        if (ctorName == null && this.config != null) {
            throw new ConfigException(
                "Config is set, but no c'tor specified to use it");
        }
        if (mainName == null) {
            if (main16Name == null) {
                throw new ConfigException(
                    "Neither 'main' nor 'main16' name not set");
            }
        } else if (main16Name != null) {
            throw new ConfigException(
                "Only one of 'main' and 'main16' allowed");
        }
    }

    @Override
    public String libraryName() {
        return libraryName;
    }

    @Override
    public String ctorName() {
        return ctorName;
    }

    @Override
    public String dtorName() {
        return dtorName;
    }

    @Override
    public String mainName() {
        return mainName;
    }

    @Override
    public String main16Name() {
        return main16Name;
    }

    @Override
    public String logrotateName() {
        return logrotateName;
    }

    @Override
    public String reloadName() {
        return reloadName;
    }

    @Override
    public String freeName() {
        return freeName;
    }

    @Override
    public String config() {
        return config;
    }

    @Override
    public int workers() {
        return workers;
    }

    @Override
    public int queueSize() {
        return queueSize;
    }
}

