package ru.yandex.jniwrapper;

import ru.yandex.function.GenericFunction;
import ru.yandex.function.NullToDefaultFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeValidator;
import ru.yandex.parser.string.PositiveValidator;

public interface JniWrapperConfig {
    ParameterConfig<String> LIBRARY_NAME =
        new ParameterConfig<>("library", x -> x, NonEmptyValidator.INSTANCE);
    ParameterConfig<String> CTOR_NAME = new ParameterConfig<>(
        "ctor",
        GenericFunction.identity(),
        new NullToDefaultFunction<>(NonEmptyValidator.INSTANCE),
        true);
    ParameterConfig<String> DTOR_NAME = new ParameterConfig<>(
        "dtor",
        GenericFunction.identity(),
        new NullToDefaultFunction<>(NonEmptyValidator.INSTANCE),
        true);
    ParameterConfig<String> MAIN_NAME = new ParameterConfig<>(
        "main",
        GenericFunction.identity(),
        new NullToDefaultFunction<>(NonEmptyValidator.INSTANCE),
        true);
    ParameterConfig<String> MAIN16_NAME = new ParameterConfig<>(
        "main16",
        GenericFunction.identity(),
        new NullToDefaultFunction<>(NonEmptyValidator.INSTANCE),
        true);
    ParameterConfig<String> LOGROTATE_NAME = new ParameterConfig<>(
        "logrotate",
        GenericFunction.identity(),
        new NullToDefaultFunction<>(NonEmptyValidator.INSTANCE),
        true);
    ParameterConfig<String> RELOAD_NAME = new ParameterConfig<>(
        "reload",
        GenericFunction.identity(),
        new NullToDefaultFunction<>(NonEmptyValidator.INSTANCE),
        true);
    ParameterConfig<String> FREE_NAME = new ParameterConfig<>(
        "free",
        GenericFunction.identity(),
        new NullToDefaultFunction<>(NonEmptyValidator.INSTANCE),
        true);
    ParameterConfig<String> CONFIG =
        new ParameterConfig<>("config", x -> x, x -> x, true);
    ParameterConfig<Integer> WORKERS = new ParameterConfig<>(
        "workers",
        Integer::valueOf,
        NonNegativeValidator.instance());
    ParameterConfig<Integer> QUEUE_SIZE = new ParameterConfig<>(
        "queue-size",
        Integer::valueOf,
        PositiveValidator.instance());

    String libraryName();

    String ctorName();

    String dtorName();

    String mainName();

    String main16Name();

    String logrotateName();

    String reloadName();

    String freeName();

    String config();

    int workers();

    int queueSize();
}

