package ru.yandex.jniwrapper;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class JniWrapperConfigBuilder
    extends AbstractJniWrapperConfigBuilder<JniWrapperConfigBuilder>
{
    public JniWrapperConfigBuilder() {
        super(JniWrapperConfigDefaults.INSTANCE);
    }

    public JniWrapperConfigBuilder(final JniWrapperConfig config) {
        super(config);
    }

    public JniWrapperConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, JniWrapperConfigDefaults.INSTANCE);
    }

    public JniWrapperConfigBuilder(
        final IniConfig config,
        final JniWrapperConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public JniWrapperConfigBuilder self() {
        return this;
    }

    public ImmutableJniWrapperConfig build() throws ConfigException {
        return new ImmutableJniWrapperConfig(this);
    }
}

