package ru.yandex.jniwrapper;

import ru.yandex.function.ByteArrayProcessor;
import ru.yandex.function.Processor;

public class ThreadSafeJniWrapper extends JniWrapper {
    private final long instance;

    public ThreadSafeJniWrapper(final ImmutableJniWrapperConfig config)
        throws JniWrapperException
    {
        super(config);
        instance = createInstance();
    }

    @Override
    protected void onClose() {
        destroyInstance(instance);
        super.onClose();
    }

    @Override
    public void logrotate() {
        logrotate(instance);
    }

    @Override
    public void reload() {
        reload(instance);
    }

    @Override
    public Processor<byte[], String, JniWrapperException> apply(
        final String uri,
        final String metainfo)
    {
        return new JniProcessor(uri, metainfo);
    }

    private class JniProcessor
        implements ByteArrayProcessor<String, JniWrapperException>
    {
        private final String uri;
        private final String metainfo;

        JniProcessor(final String uri, final String metainfo) {
            this.uri = uri;
            this.metainfo = metainfo;
        }

        @Override
        public String process(final byte[] buf, final int off, final int len)
            throws JniWrapperException
        {
            try {
                return ThreadSafeJniWrapper.this.process(
                    instance,
                    uri,
                    metainfo,
                    buf,
                    off,
                    len);
            } catch (IllegalArgumentException e) {
                throw new JniWrapperUnprocessableInputException(e);
            } catch (RuntimeException e) {
                throw new JniWrapperException(e);
            }
        }
    }
}

