package ru.yandex.json.async.consumer;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.BasicGenericConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.ValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StackContentHandler;
import ru.yandex.json.parser.StringCollectorFactory;

public abstract class AbstractJsonAsyncDomConsumer<T>
    extends JsonAsyncConsumer<T>
{
    private final BasicGenericConsumer<Object, JsonException> consumer;

    protected AbstractJsonAsyncDomConsumer(final HttpEntity entity)
        throws HttpException
    {
        this(entity, new BasicGenericConsumer<>());
    }

    private AbstractJsonAsyncDomConsumer(
        final HttpEntity entity,
        final BasicGenericConsumer<Object, JsonException> consumer)
        throws HttpException
    {
        super(
            entity,
            new StackContentHandler(
                new ValueContentHandler(
                    consumer,
                    StringCollectorFactory.INSTANCE.create(
                        contentLength(entity)),
                    BasicContainerFactory.INSTANCE)));
        this.consumer = consumer;
    }

    protected abstract T buildResult(
        final HttpContext context,
        final Object value)
        throws Exception;

    @Override
    protected T doBuildResult(final HttpContext context) throws Exception {
        return buildResult(context, consumer.get());
    }
}

