package ru.yandex.json.async.consumer;

import java.util.function.LongFunction;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.BasicGenericConsumer;
import ru.yandex.json.dom.ContainerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StackContentHandler;
import ru.yandex.json.parser.StringCollectors;

public abstract class AbstractJsonAsyncTypesafeDomConsumer<T>
    extends JsonAsyncConsumer<T>
{
    private final BasicGenericConsumer<JsonObject, JsonException> consumer;

    protected AbstractJsonAsyncTypesafeDomConsumer(
        final HttpEntity entity,
        final LongFunction<StringCollectors> stringCollectorsFactory,
        final ContainerFactory containerFactory)
        throws HttpException
    {
        this(
            entity,
            stringCollectorsFactory,
            containerFactory,
            new BasicGenericConsumer<JsonObject, JsonException>());
    }

    private AbstractJsonAsyncTypesafeDomConsumer(
        final HttpEntity entity,
        final LongFunction<StringCollectors> stringCollectorsFactory,
        final ContainerFactory containerFactory,
        final BasicGenericConsumer<JsonObject, JsonException> consumer)
        throws HttpException
    {
        super(
            entity,
            new StackContentHandler(
                new TypesafeValueContentHandler(
                    consumer,
                    stringCollectorsFactory.apply(contentLength(entity)),
                    containerFactory)));
        this.consumer = consumer;
    }

    protected abstract T buildResult(
        final HttpContext context,
        final JsonObject value)
        throws Exception;

    @Override
    protected T doBuildResult(final HttpContext context) throws Exception {
        return buildResult(context, consumer.get());
    }
}

