package ru.yandex.json.async.consumer;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.function.LongFunction;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.nio.IOControl;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.IOHttpException;
import ru.yandex.http.util.nio.AsyncCharConsumer;
import ru.yandex.json.parser.ContentHandler;
import ru.yandex.json.parser.ExceptionHandlingContentHandler;
import ru.yandex.json.parser.JsonParser;
import ru.yandex.json.parser.StringCollectors;
import ru.yandex.json.xpath.PrimitiveHandler;
import ru.yandex.json.xpath.XPathContentHandler;

public abstract class JsonAsyncConsumer<T> extends AsyncCharConsumer<T> {
    protected final JsonParser parser;

    protected JsonAsyncConsumer(
        final HttpEntity entity,
        final PrimitiveHandler handler,
        final LongFunction<StringCollectors> stringCollectorsFactory)
        throws HttpException
    {
        this(
            entity,
            new XPathContentHandler(
                handler,
                stringCollectorsFactory.apply(
                    entity.getContentLength())));
    }

    protected JsonAsyncConsumer(
        final HttpEntity entity,
        final XPathContentHandler handler)
        throws HttpException
    {
        this(entity, new ExceptionHandlingContentHandler(handler, handler));
    }

    protected JsonAsyncConsumer(
        final HttpEntity entity,
        final ContentHandler handler)
        throws HttpException
    {
        super(entity);
        parser = new JsonParser(handler);
    }

    protected abstract T doBuildResult(final HttpContext context)
        throws Exception;

    @Override
    protected void consumeContent(
        final CharBuffer buf,
        final IOControl ioctrl)
        throws IOException
    {
        try {
            parser.process(buf.array(), buf.arrayOffset(), buf.remaining());
        } catch (Throwable t) {
            throw new IOHttpException(
                new BadRequestException(
                    "Can't parse input <" + buf.toString() + '>',
                    t));
        }
    }

    @Override
    protected T buildResult(final HttpContext context) throws Exception {
        parser.eof();
        return doBuildResult(context);
    }
}

