package ru.yandex.json.async.consumer;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public class JsonAsyncDomConsumerFactory
    implements HttpAsyncResponseConsumerFactory<Object>
{
    public static final JsonAsyncDomConsumerFactory INSTANCE =
        new JsonAsyncDomConsumerFactory();
    public static final StatusCheckAsyncResponseConsumerFactory<Object> OK =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);

    protected JsonAsyncDomConsumerFactory() {
    }

    @Override
    public JsonAsyncDomConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new JsonAsyncDomConsumer(response.getEntity());
    }
}

