package ru.yandex.json.async.consumer;

import java.util.function.LongFunction;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.ContainerFactory;
import ru.yandex.json.dom.IdentityContainerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.PositionSavingContainerFactory;
import ru.yandex.json.parser.KeyInterningStringCollectorsFactory;
import ru.yandex.json.parser.SparseKeyStringCollectorsFactory;
import ru.yandex.json.parser.StringCollectors;
import ru.yandex.json.parser.StringCollectorsFactory;

public class JsonAsyncTypesafeDomConsumerFactory
    implements HttpAsyncResponseConsumerFactory<JsonObject>
{
    public static final JsonAsyncTypesafeDomConsumerFactory INSTANCE =
        new JsonAsyncTypesafeDomConsumerFactory(
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
    public static final JsonAsyncTypesafeDomConsumerFactory POSITION_SAVING =
        new JsonAsyncTypesafeDomConsumerFactory(
            StringCollectorsFactory.INSTANCE,
            PositionSavingContainerFactory.INSTANCE);
    public static final JsonAsyncTypesafeDomConsumerFactory SPARSE_KEY =
        new JsonAsyncTypesafeDomConsumerFactory(
            SparseKeyStringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
    public static final JsonAsyncTypesafeDomConsumerFactory INTERNING =
        new JsonAsyncTypesafeDomConsumerFactory(
            KeyInterningStringCollectorsFactory.INSTANCE,
            IdentityContainerFactory.INSTANCE);
    public static final StatusCheckAsyncResponseConsumerFactory<JsonObject>
        OK = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);
    public static final StatusCheckAsyncResponseConsumerFactory<JsonObject>
        INTERNING_OK = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INTERNING);
    public static final StatusCheckAsyncResponseConsumerFactory<JsonObject>
        POSITION_SAVING_OK = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            POSITION_SAVING);
    public static final StatusCheckAsyncResponseConsumerFactory<JsonObject>
        SPARSE_KEY_OK = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            SPARSE_KEY);
    public static final StatusCheckAsyncResponseConsumerFactory<JsonObject>
        ANY_GOOD = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.ANY_GOOD,
            INSTANCE);

    private final LongFunction<StringCollectors> stringCollectorsFactory;
    private final ContainerFactory containerFactory;

    public JsonAsyncTypesafeDomConsumerFactory(
        final LongFunction<StringCollectors> stringCollectorsFactory,
        final ContainerFactory containerFactory)
    {
        this.stringCollectorsFactory = stringCollectorsFactory;
        this.containerFactory = containerFactory;
    }

    @Override
    public JsonAsyncTypesafeDomConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new JsonAsyncTypesafeDomConsumer(
            response.getEntity(),
            stringCollectorsFactory,
            containerFactory);
    }
}

