package ru.yandex.json.async.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;

import ru.yandex.function.GenericFunction;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StringCollectorsFactory;

public class JsonStreamAsyncConsumerFactory<T>
    implements HttpAsyncResponseConsumerFactory<List<T>>
{
    private final GenericFunction<JsonObject, T, JsonException> consumer;
    private final Supplier<List<T>> supplier;

    public JsonStreamAsyncConsumerFactory(
        final GenericFunction<JsonObject, T, JsonException> consumer)
    {
        this(consumer, ArrayList::new);
    }

    public JsonStreamAsyncConsumerFactory(
        final GenericFunction<JsonObject, T, JsonException> consumer,
        final Supplier<List<T>> supplier)
    {
        this.consumer = consumer;
        this.supplier = supplier;
    }

    @Override
    public HttpAsyncResponseConsumer<List<T>> create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new JsonStreamAsyncConsumer<>(
            response.getEntity(),
            consumer,
            supplier,
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
    }
}
