package ru.yandex.json.dom;

import ru.yandex.function.GenericConsumer;
import ru.yandex.function.GenericRunnable;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StringCollector;

public class ArrayContentHandler extends ValueContentHandler {
    private final GenericRunnable<? extends JsonException> completionCallback;

    // CSOFF: ParameterNumber
    public ArrayContentHandler(
        final GenericConsumer<Object, ? extends JsonException> consumer,
        final StringCollector stringCollector,
        final ContainerFactory containerFactory,
        final GenericRunnable<? extends JsonException> completionCallback)
    {
        super(consumer, stringCollector, containerFactory);
        this.completionCallback = completionCallback;
    }
    // CSON: ParameterNumber

    @Override
    public void endArray() throws JsonException {
        stackContentHandler.pop();
        completionCallback.run();
    }
}

