package ru.yandex.json.dom;

import ru.yandex.function.BasicGenericConsumer;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.JsonParser;
import ru.yandex.json.parser.StackContentHandler;

public class BasicTypeSafeJsonParser {
    private final JsonParser parser;
    private final BasicGenericConsumer<JsonObject, JsonException> consumer;

    public BasicTypeSafeJsonParser() {
        consumer = new BasicGenericConsumer<>();
        parser =
            new JsonParser(
                new StackContentHandler(
                    new TypesafeValueContentHandler(consumer)));
    }

    public JsonObject parse(final String json) throws JsonException {
        parser.parse(json);
        return consumer.get();
    }
}
