package ru.yandex.json.dom;

import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;

public class JsonBadCastException extends JsonException {
    private static final long serialVersionUID = 0;

    public JsonBadCastException(final JsonObject from, final String to) {
        super(message(from, to));
    }

    public JsonBadCastException(
        final JsonObject from,
        final String to,
        final Throwable cause)
    {
        super(message(from, to), cause);
    }

    private static String message(final JsonObject from, final String to) {
        return from.getClass().getName() + " with value <"
            + JsonType.NORMAL.toString(from) + "> can not be casted to " + to;
    }
}

