package ru.yandex.json.dom;

import java.io.IOException;

import ru.yandex.json.writer.JsonWriterBase;

public enum JsonBoolean implements JsonObject {
    TRUE(true),
    FALSE(false);

    private final boolean value;

    JsonBoolean(final boolean value) {
        this.value = value;
    }

    public static JsonObject valueOf(final Boolean value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        } else {
            return valueOf(value.booleanValue());
        }
    }

    public static JsonBoolean valueOf(final boolean value) {
        if (value) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    @Override
    public Type type() {
        return Type.BOOLEAN;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public JsonBoolean deepCopy(final ContainerFactory containerFactory) {
        return this;
    }

    @Override
    public JsonBoolean filter(
        final JsonObjectFilter filter,
        final ContainerFactory containerFactory)
    {
        return this;
    }

    @Override
    public boolean asBoolean() {
        return value;
    }

    @Override
    public String asString() {
        return Boolean.toString(value);
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.value(value);
    }
}

