package ru.yandex.json.dom;

import java.io.IOException;

import ru.yandex.json.writer.JsonWriterBase;

public class JsonDouble implements JsonObject {
    private final double value;

    public JsonDouble(final double value) {
        this.value = value;
    }

    @Override
    public Type type() {
        return Type.DOUBLE;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public JsonDouble deepCopy(final ContainerFactory containerFactory) {
        return this;
    }

    @Override
    public JsonDouble filter(
        final JsonObjectFilter filter,
        final ContainerFactory containerFactory)
    {
        return this;
    }

    @Override
    public long asLong() throws JsonBadCastException {
        if (value >= Long.MIN_VALUE && value <= Long.MAX_VALUE
            && (value % 1d == 0d))
        {
            return (long) value;
        } else {
            throw new JsonBadCastException(this, "long");
        }
    }

    @Override
    public double asDouble() {
        return value;
    }

    @Override
    public String asString() {
        return Double.toString(value);
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.value(value);
    }

    @Override
    public int hashCode() {
        return Double.hashCode(value);
    }

    @Override
    public boolean equals(final Object o) {
        return o instanceof JsonDouble && value == ((JsonDouble) o).value;
    }
}

