package ru.yandex.json.dom;

import java.io.IOException;

import ru.yandex.json.writer.JsonWriterBase;

public class JsonLong implements JsonObject {
    private static final int CACHE_SIZE = 65536;
    private static final JsonLong[] CACHE = new JsonLong[CACHE_SIZE];

    static {
        for (int i = 0; i < CACHE_SIZE; ++i) {
            CACHE[i] = new JsonLong(i);
        }
    }

    public static final JsonLong ZERO = valueOf(0L);
    public static final JsonLong ONE = valueOf(1L);

    private final long value;

    public JsonLong(final long value) {
        this.value = value;
    }

    public static JsonLong valueOf(final long value) {
        if (value >= 0L && value < CACHE_SIZE) {
            return CACHE[(int) value];
        } else {
            return new JsonLong(value);
        }
    }

    @Override
    public Type type() {
        return Type.LONG;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public JsonLong deepCopy(final ContainerFactory containerFactory) {
        return this;
    }

    @Override
    public JsonLong filter(
        final JsonObjectFilter filter,
        final ContainerFactory containerFactory)
    {
        return this;
    }

    @Override
    public boolean asBoolean() throws JsonBadCastException {
        if (value == 0L) {
            return false;
        } else if (value == 1L) {
            return true;
        } else {
            throw new JsonBadCastException(this, "boolean");
        }
    }

    @Override
    public long asLong() {
        return value;
    }

    @Override
    public double asDouble() {
        return value;
    }

    @Override
    public String asString() {
        return Long.toString(value);
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.value(value);
    }

    @Override
    public int hashCode() {
        return Long.hashCode(value);
    }

    @Override
    public boolean equals(final Object o) {
        return o instanceof JsonLong && value == ((JsonLong) o).value;
    }
}

