package ru.yandex.json.dom;

import java.io.IOException;

import ru.yandex.json.writer.JsonWriterBase;

public enum JsonNull implements JsonObject {
    INSTANCE;

    @Override
    public Type type() {
        return Type.NULL;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public JsonNull deepCopy(final ContainerFactory containerFactory) {
        return this;
    }

    @Override
    public JsonNull filter(
        final JsonObjectFilter filter,
        final ContainerFactory containerFactory)
    {
        return this;
    }

    @Override
    public Boolean asBooleanOrNull() {
        return null;
    }

    @Override
    public Long asLongOrNull() {
        return null;
    }

    @Override
    public Double asDoubleOrNull() {
        return null;
    }

    @Override
    public String asStringOrNull() {
        return null;
    }

    @Override
    public JsonList asListOrNull() {
        return null;
    }

    @Override
    public JsonMap asMapOrNull() {
        return null;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.nullValue();
    }
}

