package ru.yandex.json.dom;

import java.io.IOException;

import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.parser.string.BooleanParser;

public class JsonString implements JsonObject {
    public static final JsonString EMPTY = new JsonString("");

    private final String value;

    public JsonString(final String value) {
        this.value = value;
    }

    public static JsonObject valueOf(final String value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        } else {
            return new JsonString(value);
        }
    }

    @Override
    public Type type() {
        return Type.STRING;
    }

    @Override
    public boolean isEmpty() {
        return value.isEmpty();
    }

    @Override
    public JsonString deepCopy(final ContainerFactory containerFactory) {
        return this;
    }

    @Override
    public JsonString filter(
        final JsonObjectFilter filter,
        final ContainerFactory containerFactory)
    {
        return this;
    }

    @Override
    public boolean asBoolean() throws JsonBadCastException {
        try {
            return BooleanParser.INSTANCE.apply(value);
        } catch (Exception e) {
            throw new JsonBadCastException(this, "boolean");
        }
    }

    @Override
    public long asLong() throws JsonBadCastException {
        try {
            return Long.parseLong(value);
        } catch (Exception e) {
            throw new JsonBadCastException(this, "long", e);
        }
    }

    @Override
    public double asDouble() throws JsonBadCastException {
        try {
            return Double.parseDouble(value);
        } catch (Exception e) {
            throw new JsonBadCastException(this, "double", e);
        }
    }

    @Override
    public String asString() {
        return value;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.value(value);
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        return o instanceof JsonString && value.equals(((JsonString) o).value);
    }
}

