package ru.yandex.json.dom;

import java.util.Map;

import ru.yandex.function.GenericConsumer;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StackedContentHandler;
import ru.yandex.json.parser.StringCollector;

public class ObjectContentHandler extends StackedContentHandler {
    private final StringBuilder key = new StringBuilder();
    private final GenericConsumer<Object, ? extends JsonException> consumer;
    private final Map<String, Object> map;
    private final StringCollector stringCollector;
    private final ContainerFactory containerFactory;

    // CSOFF: ParameterNumber
    public ObjectContentHandler(
        final GenericConsumer<Object, ? extends JsonException> consumer,
        final Map<String, Object> map,
        final StringCollector stringCollector,
        final ContainerFactory containerFactory)
    {
        this.consumer = consumer;
        this.map = map;
        this.stringCollector = stringCollector;
        this.containerFactory = containerFactory;
    }

    @Override
    public void key(
        final char[] buf,
        final int off,
        final int len,
        final boolean eol)
    {
        key.append(buf, off, len);
        if (eol) {
            stackContentHandler.push(
                new ObjectEntryContentHandler(
                    new ValueConsumer(key.toString().intern(), map),
                    stringCollector,
                    containerFactory));
            key.setLength(0);
        }
    }
    // CSON: ParameterNumber

    @Override
    public void endObject() throws JsonException {
        stackContentHandler.pop();
        consumer.accept(map);
    }

    private static class ValueConsumer
        implements GenericConsumer<Object, JsonException>
    {
        private final String key;
        private final Map<String, Object> map;

        ValueConsumer(final String key, final Map<String, Object> map) {
            this.key = key;
            this.map = map;
        }

        @Override
        public void accept(final Object value) {
            map.put(key, value);
        }
    }
}

