package ru.yandex.json.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public enum OrderingContainerFactory implements ContainerFactory {
    INSTANCE;

    @Override
    public <T> List<T> createArrayContainer() {
        return new ArrayList<>();
    }

    @Override
    public <T> List<T> createArrayContainer(final int size) {
        return new ArrayList<>(size);
    }

    @Override
    public <K, V> Map<K, V> createObjectContainer() {
        return new TreeMap<>();
    }

    @Override
    public <K, V> Map<K, V> createObjectContainer(final int size) {
        return new TreeMap<>();
    }
}

