package ru.yandex.json.dom;

import ru.yandex.function.GenericConsumer;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StackContentHandler;

public class PopValueContentHandler extends ValueContentHandler {
    private final PopConsumer popConsumer;

    public PopValueContentHandler(
        final GenericConsumer<Object, ? extends JsonException> consumer)
    {
        this(new PopConsumer(consumer));
    }

    private PopValueContentHandler(final PopConsumer popConsumer) {
        super(popConsumer);
        this.popConsumer = popConsumer;
    }

    @Override
    public void stackContentHandler(
        final StackContentHandler stackContentHandler)
    {
        super.stackContentHandler(stackContentHandler);
        popConsumer.stackContentHandler(stackContentHandler);
    }

    private static class PopConsumer
        implements GenericConsumer<Object, JsonException>
    {
        private final GenericConsumer<Object, ? extends JsonException>
            consumer;
        private StackContentHandler stackContentHandler = null;

        PopConsumer(
            final GenericConsumer<Object, ? extends JsonException> consumer)
        {
            this.consumer = consumer;
        }

        @Override
        public void accept(final Object object) throws JsonException {
            consumer.accept(object);
            stackContentHandler.pop();
        }

        public void stackContentHandler(
            final StackContentHandler stackContentHandler)
        {
            this.stackContentHandler = stackContentHandler;
        }
    }
}

