package ru.yandex.json.dom;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public enum PositionSavingContainerFactory implements ContainerFactory {
    INSTANCE;

    @Override
    public <T> List<T> createArrayContainer() {
        return new ArrayList<>();
    }

    @Override
    public <T> List<T> createArrayContainer(final int size) {
        return new ArrayList<>(size);
    }

    @Override
    public <K, V> Map<K, V> createObjectContainer() {
        return new LinkedHashMap<>();
    }

    @Override
    public <K, V> Map<K, V> createObjectContainer(final int size) {
        return new LinkedHashMap<>((size << 2) / (2 + 1));
    }
}

