package ru.yandex.json.dom;

import ru.yandex.function.GenericConsumer;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StringCollectors;

public class TypesafeArrayContentHandler extends TypesafeValueContentHandler {
    private final JsonList list;
    private final GenericConsumer<JsonObject, ? extends JsonException>
        listConsumer;

    public TypesafeArrayContentHandler(
        final StringCollectors stringCollectors,
        final ContainerFactory containerFactory,
        final GenericConsumer<JsonObject, ? extends JsonException>
            listConsumer)
    {
        this(
            new JsonList(containerFactory),
            stringCollectors,
            containerFactory,
            listConsumer);
    }

    // CSOFF: ParameterNumber
    private TypesafeArrayContentHandler(
        final JsonList list,
        final StringCollectors stringCollectors,
        final ContainerFactory containerFactory,
        final GenericConsumer<JsonObject, ? extends JsonException>
            listConsumer)
    {
        super(list, stringCollectors, containerFactory);
        this.list = list;
        this.listConsumer = listConsumer;
    }
    // CSON: ParameterNumber

    @Override
    public void endArray() throws JsonException {
        stackContentHandler.pop();
        // listConsumer.accept(list) must be called only after all elements
        // added to the list, otherwise XPath matching may fail
        listConsumer.accept(list);
    }
}

