package ru.yandex.json.dom;

import ru.yandex.function.GenericConsumer;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StackedContentHandler;
import ru.yandex.json.parser.StringCollectors;

public class TypesafeObjectContentHandler extends StackedContentHandler {
    private final GenericConsumer<JsonObject, ? extends JsonException>
        consumer;
    private final StringCollectors stringCollectors;
    private final ContainerFactory containerFactory;
    private final JsonMap map;

    public TypesafeObjectContentHandler(
        final GenericConsumer<JsonObject, ? extends JsonException> consumer,
        final StringCollectors stringCollectors,
        final ContainerFactory containerFactory)
    {
        this.consumer = consumer;
        this.stringCollectors = stringCollectors;
        this.containerFactory = containerFactory;
        map = new JsonMap(containerFactory);
    }

    // CSOFF: ParameterNumber
    @Override
    public void key(
        final char[] buf,
        final int off,
        final int len,
        final boolean eol)
    {
        if (eol) {
            stackContentHandler.push(
                new TypesafeObjectEntryContentHandler(
                    new ValueConsumer(
                        stringCollectors.keyStringCollector()
                            .appendLast(buf, off, len),
                        map),
                    stringCollectors,
                    containerFactory));
        } else {
            stringCollectors.keyStringCollector().append(buf, off, len);
        }
    }
    // CSON: ParameterNumber

    @Override
    public void endObject() throws JsonException {
        stackContentHandler.pop();
        consumer.accept(map);
    }

    private static class ValueConsumer
        implements GenericConsumer<JsonObject, JsonException>
    {
        private final String key;
        private final JsonMap map;

        ValueConsumer(final String key, final JsonMap map) {
            this.key = key;
            this.map = map;
        }

        @Override
        public void accept(final JsonObject value) {
            map.put(key, value);
        }
    }
}

